CREATE TABLE IF NOT EXISTS `#__rsform_components` (
  `ComponentId` int(11) NOT NULL auto_increment, 
  `FormId` int(11) NOT NULL default '0', 
  `ComponentTypeId` int(11) NOT NULL default '0',
  `Order` int(11) NOT NULL default '0',
  `Published` tinyint(1) NOT NULL default '1',
  UNIQUE KEY `ComponentId` (`ComponentId`),
  KEY `ComponentTypeId` (`ComponentTypeId`),
  KEY `FormId` (`FormId`)
);

CREATE TABLE IF NOT EXISTS `#__rsform_component_types` (
  `ComponentTypeId` int(11) NOT NULL auto_increment,
  `ComponentTypeName` text NOT NULL,
  PRIMARY KEY  (`ComponentTypeId`)
);

CREATE TABLE IF NOT EXISTS `#__rsform_component_type_fields` (
  `ComponentTypeFieldId` int(11) NOT NULL auto_increment,
  `ComponentTypeId` int(11) NOT NULL default '0',
  `FieldName` text NOT NULL,
  `FieldType` enum('hidden','hiddenparam','textbox','textarea','select','emailattach') NOT NULL default 'hidden',
  `FieldValues` text NOT NULL,
  `Ordering` int(11) NOT NULL default '0',
  PRIMARY KEY  (`ComponentTypeFieldId`),
  KEY `ComponentTypeId` (`ComponentTypeId`)
);

CREATE TABLE IF NOT EXISTS `#__rsform_config` (
  `ConfigId` int(11) NOT NULL auto_increment,
  `SettingName` varchar(64) NOT NULL default '',
  `SettingValue` text NOT NULL,
  PRIMARY KEY  (`ConfigId`)
);

CREATE TABLE IF NOT EXISTS `#__rsform_forms` (
  `FormId` int(11) NOT NULL auto_increment,
  `FormName` text NOT NULL,
  `FormLayout` longtext NOT NULL,
  `FormLayoutName` text NOT NULL,
  `FormLayoutAutogenerate` tinyint(1) NOT NULL default '1',
  `CSS` text NOT NULL,
  `JS` text NOT NULL,
  `FormTitle` text NOT NULL,
  `Published` tinyint(1) NOT NULL default '1',
  `Lang` varchar(255) NOT NULL default '',
  `ReturnUrl` text NOT NULL,
  `ShowThankyou` tinyint(1) NOT NULL default '1',
  `Thankyou` text NOT NULL,
  `ShowContinue` tinyint(1) NOT NULL default '1',
  `UserEmailText` text NOT NULL,
  `UserEmailTo` text NOT NULL,
  `UserEmailCC` varchar(255) NOT NULL,
  `UserEmailBCC` varchar(255) NOT NULL,
  `UserEmailFrom` varchar(255) NOT NULL default '',
  `UserEmailReplyTo` varchar(255) NOT NULL,
  `UserEmailFromName` varchar(255) NOT NULL default '',
  `UserEmailSubject` varchar(255) NOT NULL default '',
  `UserEmailMode` tinyint(4) NOT NULL default '1',
  `UserEmailAttach` tinyint(4) NOT NULL,
  `UserEmailAttachFile` varchar(255) NOT NULL,
  `AdminEmailText` text NOT NULL,
  `AdminEmailTo` text NOT NULL,
  `AdminEmailCC` varchar(255) NOT NULL,
  `AdminEmailBCC` varchar(255) NOT NULL,
  `AdminEmailFrom` varchar(255) NOT NULL default '',
  `AdminEmailReplyTo` varchar(255) NOT NULL,
  `AdminEmailFromName` varchar(255) NOT NULL default '',
  `AdminEmailSubject` varchar(255) NOT NULL default '',
  `AdminEmailMode` tinyint(4) NOT NULL default '1',
  `ScriptProcess` text NOT NULL,
  `ScriptProcess2` text NOT NULL,
  `ScriptDisplay` text NOT NULL,
  `UserEmailScript` text NOT NULL,
  `AdminEmailScript` text NOT NULL,
  `MetaTitle` tinyint(1) NOT NULL,
  `MetaDesc` text NOT NULL,
  `MetaKeywords` text NOT NULL,
  `Required` varchar(255) NOT NULL default '(*)',
  `ErrorMessage` text NOT NULL,
  `MultipleSeparator` varchar(64) NOT NULL default '\\n',
  `TextareaNewLines` tinyint(1) NOT NULL default '1',
  `CSSClass` varchar(255) NOT NULL,
  `CSSId` varchar(255) NOT NULL default 'userForm',
  `CSSName` varchar(255) NOT NULL,
  `CSSAction` text NOT NULL,
  `CSSAdditionalAttributes` text NOT NULL,
  `AjaxValidation` tinyint(1) NOT NULL,
  `ThemeParams` text NOT NULL,
  `Keepdata` tinyint(1) NOT NULL default '1',
  `Backendmenu` tinyint(1) NOT NULL,
  `ConfirmSubmission` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY  (`FormId`)
);

CREATE TABLE IF NOT EXISTS `#__rsform_emails` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `formId` int(11) NOT NULL,
  `from` varchar(255) NOT NULL,
  `fromname` varchar(255) NOT NULL,
  `replyto` varchar(255) NOT NULL,
  `to` varchar(255) NOT NULL,
  `cc` varchar(255) NOT NULL,
  `bcc` varchar(255) NOT NULL,
  `subject` varchar(255) NOT NULL,
  `mode` tinyint(1) NOT NULL,
  `message` text NOT NULL,
  PRIMARY KEY (`id`)
);

CREATE TABLE IF NOT EXISTS `#__rsform_properties` (
  `PropertyId` int(11) NOT NULL auto_increment,
  `ComponentId` int(11) NOT NULL default '0',
  `PropertyName` text NOT NULL,
  `PropertyValue` text NOT NULL,
  UNIQUE KEY `PropertyId` (`PropertyId`),
  KEY `ComponentId` (`ComponentId`)
);

CREATE TABLE IF NOT EXISTS `#__rsform_submissions` (
  `SubmissionId` int(11) NOT NULL auto_increment,
  `FormId` int(11) NOT NULL default '0',
  `DateSubmitted` datetime NOT NULL ,
  `UserIp` varchar(15) NOT NULL default '',
  `Username` varchar(255) NOT NULL default '',
  `UserId` text NOT NULL,
  `Lang` varchar(255) NOT NULL,
  `confirmed` tinyint(1) NOT NULL,
  PRIMARY KEY  (`SubmissionId`),
  KEY `FormId` (`FormId`)
);

CREATE TABLE IF NOT EXISTS `#__rsform_submission_values` (
  `SubmissionValueId` int(11) NOT NULL auto_increment,
  `FormId` int(11) NOT NULL,
  `SubmissionId` int(11) NOT NULL default '0',
  `FieldName` text NOT NULL,
  `FieldValue` text NOT NULL,
  PRIMARY KEY  (`SubmissionValueId`),
  KEY `FormId` (`FormId`),
  KEY `SubmissionId` (`SubmissionId`)
);

CREATE TABLE IF NOT EXISTS `#__rsform_submission_columns` (
  `FormId` int(11) NOT NULL,
  `ColumnName` varchar(255) NOT NULL,
  `ColumnStatic` tinyint(1) NOT NULL,
  PRIMARY KEY  (`FormId`,`ColumnName`,`ColumnStatic`)
);

CREATE TABLE IF NOT EXISTS `#__rsform_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `formId` int(11) NOT NULL,
  `connection` tinyint(1) NOT NULL,
  `host` varchar(255) NOT NULL,
  `port` int(10) NOT NULL,
  `username` varchar(255) NOT NULL,
  `password` varchar(255) NOT NULL,
  `database` varchar(255) NOT NULL,
  `method` tinyint(1) NOT NULL,
  `table` varchar(255) NOT NULL,
  `data` text NOT NULL,
  `wheredata` text NOT NULL,
  `extra` text NOT NULL,
  `andor` text NOT NULL,
  `ordering` int(11) NOT NULL,
  PRIMARY KEY (`id`)
);

REPLACE INTO `#__rsform_component_types`
(`ComponentTypeId`, `ComponentTypeName`)
VALUES
(1, 'textBox'),
(2, 'textArea'),
(3, 'selectList'),
(4, 'checkboxGroup'),
(5, 'radioGroup'),
(6, 'calendar'),
(7, 'button'),
(8, 'captcha'),
(9, 'fileUpload'),
(10, 'freeText'),
(11, 'hidden'),
(12, 'imageButton'),
(13, 'submitButton'),
(14, 'password'),
(15, 'ticket'),
(41, 'pageBreak');

REPLACE INTO `#__rsform_component_type_fields`
(`ComponentTypeFieldId`, `ComponentTypeId`, `FieldName`, `FieldType`, `FieldValues`, `Ordering`)
VALUES
(2, 1, 'NAME', 'textbox', '', 1),
(3, 1, 'CAPTION', 'textbox', '', 2),
(4, 1, 'REQUIRED', 'select', 'NO\r\nYES', 3),
(5, 1, 'SIZE', 'textbox', '20', 4),
(6, 1, 'MAXSIZE', 'textbox', '', 5),
(7, 1, 'VALIDATIONRULE', 'select', '//<code>\r\nreturn RSFormProHelper::getValidationRules();\r\n//</code>', 6),
(8, 1, 'VALIDATIONMESSAGE', 'textarea', 'INVALIDINPUT', 7),
(9, 1, 'ADDITIONALATTRIBUTES', 'textarea', '', 8),
(10, 1, 'DEFAULTVALUE', 'textarea', '', 9),
(11, 1, 'DESCRIPTION', 'textarea', '', 11),
(12, 1, 'COMPONENTTYPE', 'hidden', '1', 15),
(13, 2, 'NAME', 'textbox', '', 1),
(14, 2, 'CAPTION', 'textbox', '', 2),
(15, 2, 'REQUIRED', 'select', 'NO\r\nYES', 3),
(16, 2, 'COLS', 'textbox', '50', 4),
(17, 2, 'ROWS', 'textbox', '5', 5),
(18, 2, 'VALIDATIONRULE', 'select', '//<code>\r\nreturn RSFormProHelper::getValidationRules();\r\n//</code>', 6),
(19, 2, 'VALIDATIONMESSAGE', 'textarea', 'INVALIDINPUT', 7),
(20, 2, 'ADDITIONALATTRIBUTES', 'textarea', '', 8),
(21, 2, 'DEFAULTVALUE', 'textarea', '', 9),
(22, 2, 'DESCRIPTION', 'textarea', '', 10),
(23, 2, 'COMPONENTTYPE', 'hidden', '2', 10),
(24, 3, 'NAME', 'textbox', '', 1),
(25, 3, 'CAPTION', 'textbox', '', 2),
(26, 3, 'SIZE', 'textbox', '', 3),
(27, 3, 'MULTIPLE', 'select', 'NO\r\nYES', 4),
(28, 3, 'ITEMS', 'textarea', '', 5),
(29, 3, 'REQUIRED', 'select', 'NO\r\nYES', 6),
(30, 3, 'ADDITIONALATTRIBUTES', 'textarea', '', 7),
(31, 3, 'DESCRIPTION', 'textarea', '', 8),
(32, 3, 'COMPONENTTYPE', 'hidden', '3', 10),
(33, 4, 'NAME', 'textbox', '', 1),
(34, 4, 'CAPTION', 'textbox', '', 2),
(35, 4, 'ITEMS', 'textarea', '', 3),
(36, 4, 'FLOW', 'select', 'HORIZONTAL\r\nVERTICAL', 4),
(37, 4, 'REQUIRED', 'select', 'NO\r\nYES', 5),
(38, 4, 'ADDITIONALATTRIBUTES', 'textarea', '', 6),
(39, 4, 'DESCRIPTION', 'textarea', '', 6),
(40, 4, 'COMPONENTTYPE', 'hidden', '4', 7),
(41, 5, 'NAME', 'textbox', '', 1),
(42, 5, 'CAPTION', 'textbox', '', 2),
(43, 5, 'ITEMS', 'textarea', '', 3),
(44, 5, 'FLOW', 'select', 'HORIZONTAL\r\nVERTICAL', 4),
(45, 5, 'REQUIRED', 'select', 'NO\r\nYES', 5),
(46, 5, 'ADDITIONALATTRIBUTES', 'textarea', '', 6),
(47, 5, 'DESCRIPTION', 'textarea', '', 6),
(48, 5, 'COMPONENTTYPE', 'hidden', '5', 7),
(49, 6, 'NAME', 'textbox', '', 1),
(50, 6, 'CAPTION', 'textbox', '', 2),
(51, 6, 'REQUIRED', 'select', 'NO\r\nYES', 3),
(52, 6, 'DATEFORMAT', 'textbox', 'DDMMYYYY', 4),
(53, 6, 'CALENDARLAYOUT', 'select', 'FLAT\r\nPOPUP', 5),
(54, 6, 'ADDITIONALATTRIBUTES', 'textarea', '', 6),
(55, 6, 'DESCRIPTION', 'textarea', '', 7),
(56, 6, 'COMPONENTTYPE', 'hidden', '6', 8),
(57, 7, 'NAME', 'textbox', '', 1),
(58, 7, 'CAPTION', 'textbox', '', 2),
(59, 7, 'LABEL', 'textbox', '', 3),
(60, 7, 'RESET', 'select', 'NO\r\nYES', 4),
(61, 7, 'RESETLABEL', 'textbox', '', 5),
(62, 7, 'ADDITIONALATTRIBUTES', 'textarea', '', 6),
(63, 7, 'DESCRIPTION', 'textarea', '', 7),
(64, 7, 'COMPONENTTYPE', 'hidden', '7', 8),
(65, 8, 'NAME', 'textbox', '', 1),
(66, 8, 'CAPTION', 'textbox', '', 2),
(67, 8, 'LENGTH', 'textbox', '4', 3),
(68, 8, 'BACKGROUNDCOLOR', 'textbox', '#FFFFFF', 4),
(69, 8, 'TEXTCOLOR', 'textbox', '#000000', 5),
(70, 8, 'TYPE', 'select', 'ALPHA\r\nNUMERIC\r\nALPHANUMERIC', 6),
(71, 8, 'ADDITIONALATTRIBUTES', 'textarea', 'style="text-align:center;width:75px;"', 7),
(72, 8, 'DESCRIPTION', 'textarea', '', 9),
(73, 8, 'COMPONENTTYPE', 'hidden', '8', 9),
(74, 9, 'NAME', 'textbox', '', 1),
(75, 9, 'CAPTION', 'textbox', '', 2),
(76, 9, 'FILESIZE', 'textbox', '', 3),
(77, 9, 'REQUIRED', 'select', 'NO\r\nYES', 4),
(78, 9, 'ACCEPTEDFILES', 'textarea', '', 5),
(79, 9, 'DESTINATION', 'textbox', '//<code>\r\nreturn JPATH_SITE.DS.''components''.DS.''com_rsform''.DS.''uploads''.DS;\r\n//</code>', 6),
(80, 9, 'ADDITIONALATTRIBUTES', 'textarea', '', 7),
(81, 9, 'DESCRIPTION', 'textarea', '', 8),
(82, 9, 'COMPONENTTYPE', 'hidden', '9', 9),
(83, 10, 'NAME', 'textbox', '', 1),
(84, 10, 'TEXT', 'textarea', '', 1),
(85, 10, 'COMPONENTTYPE', 'hidden', '10', 9),
(86, 11, 'NAME', 'textbox', '', 1),
(87, 11, 'DEFAULTVALUE', 'textarea', '', 1),
(88, 11, 'ADDITIONALATTRIBUTES', 'textarea', '', 1),
(89, 11, 'COMPONENTTYPE', 'hidden', '11', 9),
(118, 12, 'COMPONENTTYPE', 'hidden', '12', 10),
(117, 12, 'ADDITIONALATTRIBUTES', 'textarea', '', 9),
(144, 3, 'VALIDATIONMESSAGE', 'textarea', 'INVALIDINPUT', 100),
(115, 12, 'RESETLABEL', 'textbox', '', 7),
(114, 12, 'RESET', 'select', 'NO\r\nYES', 6),
(113, 12, 'IMAGERESET', 'textbox', '', 5),
(112, 12, 'IMAGEBUTTON', 'textbox', '', 4),
(111, 12, 'LABEL', 'textbox', '', 3),
(110, 12, 'CAPTION', 'textbox', '', 2),
(109, 12, 'NAME', 'textbox', '', 1),
(119, 13, 'NAME', 'textbox', '', 1),
(120, 13, 'CAPTION', 'textbox', '', 3),
(121, 13, 'LABEL', 'textbox', '', 2),
(122, 13, 'RESET', 'select', 'NO\r\nYES', 6),
(123, 13, 'RESETLABEL', 'textbox', '', 7),
(125, 13, 'ADDITIONALATTRIBUTES', 'textarea', '', 9),
(126, 13, 'COMPONENTTYPE', 'hidden', '13', 10),
(127, 14, 'NAME', 'textbox', '', 1),
(128, 14, 'CAPTION', 'textbox', '', 2),
(129, 14, 'REQUIRED', 'select', 'NO\r\nYES', 3),
(130, 14, 'SIZE', 'textbox', '', 4),
(131, 14, 'MAXSIZE', 'textbox', '', 5),
(132, 14, 'DEFAULTVALUE', 'textarea', '', 6),
(133, 14, 'ADDITIONALATTRIBUTES', 'textarea', '', 7),
(134, 14, 'COMPONENTTYPE', 'hidden', '14', 8),
(135, 15, 'NAME', 'textbox', '', 1),
(138, 15, 'LENGTH', 'textbox', '8', 4),
(140, 15, 'ADDITIONALATTRIBUTES', 'textarea', '', 7),
(141, 15, 'COMPONENTTYPE', 'hidden', '15', 8),
(142, 14, 'DESCRIPTION', 'textarea', '', 100),
(143, 8, 'VALIDATIONMESSAGE', 'textarea', 'INVALIDINPUT', 100),
(145, 4, 'VALIDATIONMESSAGE', 'textarea', 'INVALIDINPUT', 100),
(146, 5, 'VALIDATIONMESSAGE', 'textarea', 'INVALIDINPUT', 100),
(147, 6, 'VALIDATIONMESSAGE', 'textarea', 'INVALIDINPUT', 100),
(148, 14, 'VALIDATIONMESSAGE', 'textarea', 'INVALIDINPUT', 100),
(149, 9, 'VALIDATIONMESSAGE', 'textarea', 'INVALIDINPUT', 100),
(150, 8, 'FLOW', 'select', 'VERTICAL\r\nHORIZONTAL', 7),
(151, 8, 'SHOWREFRESH', 'select', 'NO\r\nYES', 8),
(152, 8, 'REFRESHTEXT', 'textbox', 'REFRESH', 11),
(153, 6, 'READONLY', 'select', 'NO\r\nYES', 6),
(154, 12, 'DESCRIPTION', 'textarea', '', 10),
(155, 6, 'POPUPLABEL', 'textbox', '...', 6),
(157, 15, 'CHARACTERS', 'select', 'ALPHANUMERIC\r\nALPHA\r\nNUMERIC', 3),
(160, 2, 'WYSIWYG', 'select', 'NO\r\nYES', 11),
(161, 8, 'SIZE', 'textbox', '15', 12),
(162, 8, 'IMAGETYPE', 'select', 'FREETYPE\r\nNOFREETYPE\r\nINVISIBLE', 3);

INSERT IGNORE INTO `#__rsform_config`
(`ConfigId`, `SettingName`, `SettingValue`)
VALUES
(1, 'global.register.code', ''),
(2, 'global.debug.mode', '0'),
(3, 'global.iis', '1'),
(4, 'global.editor', '1');

CREATE TABLE IF NOT EXISTS `#__rsform_translations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `form_id` int(11) NOT NULL,
  `lang_code` varchar(32) NOT NULL,
  `reference` varchar(255) NOT NULL,
  `reference_id` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `form_id` (`form_id`)
);